<?php

class User
{
    private $conn;

    public function __construct($db)
    {
        $this->conn = $db;
    }

    public function findByLogin($input)
    {
        $stmt = $this->conn->prepare("SELECT * FROM users WHERE username = ? OR email = ? LIMIT 1");
        $stmt->bind_param("ss", $input, $input);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function findByEmail($email)
    {
        $stmt = $this->conn->prepare("SELECT * FROM users WHERE email = ? LIMIT 1");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function createBasic($nama, $username, $wa, $email, $hash)
    {
        $stmt = $this->conn->prepare("INSERT INTO users (nama, username, nomor_wa, email, password) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sssss", $nama, $username, $wa, $email, $hash);
        return $stmt->execute();
    }
}
