<?php
require_once '../core/Controller.php';

class TenantController extends Controller
{
    public function savePrefix()
    {
        global $conn;

        if (!isset($_SESSION['user_id'])) {
            header("Location: /login");
            exit;
        }

        $prefix = strtolower(trim($_POST['prefix']));
        $prefix = preg_replace('/[^a-z0-9]/', '', $prefix);
        $userId = $_SESSION['user_id'];

        if (empty($prefix)) {
            echo "<script>alert('Prefix tidak boleh kosong'); window.location.href='/dashboard';</script>";
            exit;
        }

        // Cek duplikat prefix
        $stmt = $conn->prepare("SELECT id FROM users WHERE subdomain_prefix = ? AND id != ?");
        $stmt->bind_param("si", $prefix, $userId);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows > 0) {
            echo "<script>alert('Prefix sudah digunakan oleh pengguna lain.'); window.location.href='/dashboard';</script>";
            exit;
        }

        // Simpan ke database
        $stmt = $conn->prepare("UPDATE users SET subdomain_prefix = ? WHERE id = ?");
        $stmt->bind_param("si", $prefix, $userId);
        if ($stmt->execute()) {
            $_SESSION['subdomain_prefix'] = $prefix;
            echo "<script>alert('Prefix berhasil disimpan.'); window.location.href='/dashboard';</script>";
        } else {
            echo "<script>alert('Gagal menyimpan prefix.'); window.location.href='/dashboard';</script>";
        }
    }
}
