<?php
require_once '../models/User.php';

class AuthController extends Controller
{
    private $userModel;

    public function __construct()
    {
        global $conn;
        $this->userModel = new User($conn);
    }

    public function login()
    {
        $error = null;

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $input    = trim($_POST['email']); // Bisa email / username
            $password = $_POST['password'];

            $user = $this->userModel->findByLogin($input);

            if ($user && password_verify($password, $user['password'])) {
                if ($user['aktif'] != 1) {
                    $error = "Akun Anda belum aktif.";
                } else {
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['user_name'] = $user['nama'];
                    $_SESSION['subdomain_prefix'] = $user['subdomain_prefix'];
                    $_SESSION['role_id'] = $user['role_id'];

                    header("Location: /dashboard");
                    exit;
                }
            } else {
                $error = "Username/email atau password salah.";
            }
        }

        $this->view('auth/login', compact('error'));
    }


    public function register()
    {
        $error = null;
        $success = null;

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $nama_lengkap = trim($_POST['nama_lengkap']);
            $username     = trim($_POST['username']);
            $nomor_wa     = trim($_POST['nomor_wa']);
            $email        = trim($_POST['email']);
            $password     = $_POST['password'];
            $confirm      = $_POST['confirm'];

            if (!isset($_POST['agree'])) {
                $error = "Anda harus menyetujui syarat dan ketentuan.";
            } elseif ($password !== $confirm) {
                $error = "Password tidak cocok.";
            } elseif ($this->userModel->findByEmail($email)) {
                $error = "Email sudah terdaftar.";
            } else {
                $hash = password_hash($password, PASSWORD_BCRYPT);
                $created = $this->userModel->createBasic($nama_lengkap, $username, $nomor_wa, $email, $hash);
                if ($created) {
                    $success = "Berhasil mendaftar. Silakan login.";
                } else {
                    $error = "Gagal mendaftar.";
                }
            }
        }

        $this->view('auth/register', compact('error', 'success'));
    }

    public function logout()
    {
        session_destroy();
        header("Location: /login");
    }
}
